/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.registry;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ProxyRegistry {
    public static List<Item> items = new ArrayList<Item>();
    public static List<Block> blocks = new ArrayList<Block>();
    private static HashMap<Block, Item> itemBlockMap = new HashMap();
    private static Multimap<Class<?>, IForgeRegistryEntry<?>> entries = MultimapBuilder.hashKeys().arrayListValues().build();

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistryEntry<T> object) {
        entries.put((Object)object.getRegistryType(), object);
        if (object instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)object;
            Block block = itemBlock.func_179223_d();
            itemBlockMap.put(block, (Item)itemBlock);
        }
    }

    @SafeVarargs
    public static <T extends IForgeRegistryEntry<T>> void registerAll(IForgeRegistryEntry<T> ... object) {
        for (IForgeRegistryEntry<T> entry : object) {
            entries.put((Object)entry.getRegistryType(), entry);
        }
    }

    @SubscribeEvent
    public static void onRegister(RegistryEvent.Register event) {
        Class type = event.getRegistry().getRegistrySuperType();
        if (entries.containsKey((Object)type)) {
            Collection ourEntries = entries.get((Object)type);
            for (IForgeRegistryEntry entry : ourEntries) {
                event.getRegistry().register(entry);
            }
        }
    }

    public static Item getItemMapping(Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a && itemBlockMap.containsKey(block)) {
            return itemBlockMap.get(block);
        }
        return item;
    }

    public static ItemStack newStack(Block block) {
        return ProxyRegistry.newStack(block, 1);
    }

    public static ItemStack newStack(Block block, int size) {
        return ProxyRegistry.newStack(block, size, 0);
    }

    public static ItemStack newStack(Block block, int size, int meta) {
        return ProxyRegistry.newStack(ProxyRegistry.getItemMapping(block), size, meta);
    }

    public static ItemStack newStack(Item item) {
        return ProxyRegistry.newStack(item, 1);
    }

    public static ItemStack newStack(Item item, int size) {
        return ProxyRegistry.newStack(item, size, 0);
    }

    public static ItemStack newStack(Item item, int size, int meta) {
        return new ItemStack(item, size, meta);
    }
}

